
//////言語設定
//alert(path);


const process = window.studio_api.ipcRenderer.sendSync("getProcess");

let fs = window.studio_api.fs;

window.getExePath = () => {

    let path = window.studio_api.ipcRenderer.sendSync("getAppPath", {});

    if (process.platform == "darwin") {

        if (path.indexOf("var/folders") != -1) {

            path = process.env.HOME + "/TyranoStudio/TyranoStudio.app";
            //ファイルの存在チェック
            if (!fs.existsSync(path)) {
                alert("【macOS Alert】TyranoStudio.appの実行場所は正しいですか？" + path + "に配置したものを実行してください。");

                //app.gui.shell("dir",process.env.HOME);
                //解説用のページを表示
                location.href = "https://tyrano.jp/help/studio";
                return;

            }

            let path_index = path.indexOf("/TyranoStudio.app");
            path = path.substr(0, path_index);

        } else {

            //TyranoStudio-darwin-x64.asar
            if (path.indexOf(".asar") != -1) {
                path = path.replaceAll("/TyranoStudio.app/Contents/Resources/app.asar", "");
            } else {
                path = path.replaceAll("/TyranoStudio.app/Contents/Resources/app", "");
            }

        }

        //console.log("2::");
        //console.log(path);

    } else if (process.platform == "win32") {

        if (path.indexOf(".asar") != -1) {
            path = path.replaceAll("\\resources\\app.asar", "");
        } else {
            path = path.replaceAll("\\resources\\app", "");
        }

    }

    return path;

}

let exe_path = window.getExePath();


window.local = {};

//global_langの上書き。ビルドごとに変更したくないから
if (fs.existsSync(exe_path + "/lang/lang.txt")) {
    let tmp_lang = fs.readFileSync(exe_path + "/lang/lang.txt", "utf-8");
    global_lang = tmp_lang;
}

//外側のlangが存在するなら
if (fs.existsSync(exe_path + "/lang/" + global_lang + ".json")) {
    local[global_lang] = JSON.parse(fs.readFileSync(exe_path + "/lang/" + global_lang + ".json", "utf8"));
} else {
    //それ以外の場合は、内部のlangを読み出す
    console.log(process.__dirname + "/lang/" + global_lang + ".json");
    local[global_lang] = JSON.parse(fs.readFileSync(process.__dirname + "/lang/" + global_lang + ".json", "utf8"));
}

(function ($) {

    $.loginCheck = function (str) {
        if ($("#is_login").val() == 0) {
            if (str) {

            }
            location.href = "/users/login";
        }
    };

    $.getBaseURL = function () {

        var str = location.pathname;
        var i = str.lastIndexOf('/');
        return str.substring(0, i + 1);

    };

    $.escapeHTML = function (val, replace_str) {
        val = val || "";
        var t = $("<div/>").text(val).html();

        if (replace_str) {
            if (t === "") {
                t = replace_str;
            }
        }
        return t;
    };
    //
    $.h = function (val, replace_str) {
        return $.escapeHTML(val, replace_str);
    };

    $.br = function (txtVal) {

        txtVal = txtVal.replace(/\r\n/g, "<br />");
        txtVal = txtVal.replace(/(\n|\r)/g, "<br />");
        return txtVal;

    };

    $.f = function (obj, context) {
        var val = (typeof obj == "function") ? obj(context) : obj;
        return val;
    },

        //現在時刻を取得
        //現在の日
        $.getNowDate = function () {

            var nowdate = new Date();
            var year = nowdate.getFullYear();
            // 年
            var mon = nowdate.getMonth() + 1;
            // 月
            var date = nowdate.getDate();
            // 日

            return year + "/" + mon + "/" + date;

        };

    //現在の時刻
    $.getNowTime = function () {

        var nowdate = new Date();

        var h = nowdate.getHours();
        var m = nowdate.getMinutes();
        var s = nowdate.getSeconds();

        return h + "：" + m + "：" + s;

    };

    $.getNowDateStr = function () {
        var nowdate = new Date();
        var year = nowdate.getFullYear();
        // 年
        var mon = nowdate.getMonth() + 1;
        // 月
        var date = nowdate.getDate();
        // 日
        var h = nowdate.getHours();
        var m = nowdate.getMinutes();
        var s = nowdate.getSeconds();

        return "" + year + mon + date + "_" + h + m + s;
    };

    //確証しを取得
    $.getExt = function (str) {
        return str.split(".").pop();
    };

    $.compExt = function (filename, ext) {

        if (filename.indexOf(ext) == -1) {
            filename += ext;
        }

        return filename;

    };

    $.getExtWithFile = function (str) {

        var filename = "";
        if (str.indexOf("/") != -1) {
            filename = str.split("/").pop();
        } else {
            filename = str;
        }

        var dir_name = $.replaceAll(str, filename, "");

        var ext = "";
        if (filename.indexOf(".") != -1) {
            ext = str.split(".").pop();
        } else {
            ext = "";
        }
        var name = $.replaceAll(filename, "." + ext, "");
        return { filename: filename, ext: ext, name: name, dir_name: dir_name };


    };

    //引数が未定義の場合デフォルト値を当て込みます
    $.def = function (a, default_value) {
        if (typeof a === 'undefined') {
            return default_value;
        } else {
            return a;
        }
    };

    $.id = function (str) {
        return $("#" + str);
    };

    $.cl = function (str) {

        if (str instanceof Array) {

            var selector_str = "";
            for (var i = 0; i < str.length; i++) {
                if (str[i] !== "") {
                    selector_str = "." + str[i];
                }
            }

            return $(selector_str);

        } else {
            return $("." + str);
        }
    };

    $.tag = function (tag_name, pm, flag_space = false) {
        var pm_str = "";

        for (key in pm) {

            //空白は要素に含めない
            if ($.trim(pm[key]) == "" && flag_space == false) {
                continue;
            }

            if (key == "exp" || key == "cond") {
                pm[key] = $.replaceAll(pm[key], "&nbsp;", "");
            } else if (key.indexOf("color") != -1) {

                if (pm[key].indexOf("#") != -1) {
                    pm[key] = pm[key].replace("#", "0x");
                }

            }


            pm_str += " " + key + "=\"" + pm[key] + "\" ";
        }
        return "[" + tag_name + " " + pm_str + " ]";
    };

    $.convertSecToString = function (val) {
        if (val == 0) {
            return '-';
        }
        var day = Math.floor(val / (24 * 60 * 60));
        var hour = Math.floor((val % (24 * 60 * 60) / (60 * 60)));
        var minute = Math.floor(val % (24 * 60 * 60) % (60 * 60) / 60);
        var second = Math.floor(val % (24 * 60 * 60) % (60 * 60) % 60);

        var str = "";
        if (day !== 0) {
            str += day + "日";
        }
        if (hour !== 0) {
            str += hour + "時間";
        }
        if (minute !== 0) {
            str += minute + "分";
        }
        if (second !== 0) {
            str += second + "秒";
        }

        return str;
    };

    $.secToMinute = function (val) {
        if (val === 0) {
            return "-";
        }

        var m = Math.floor(val / 60);
        var s = Math.floor(val % 60);
        var str = "";

        if (m !== 0) {
            str += m + "分";
        }
        str += s + "秒";

        return str;
    };

    $.degToRad = function (degree) {
        return degree * (Math.PI / 180);
    }

    $.trim = function (str) {

        str = "" + str;
        if (str == "") return "";

        if (str) {

        } else {
            return "";
        }

        return str.replace(/^\s+|\s+$/g, "");
    };

    $.rmspace = function (str) {

        str = str.replace(/ /g, "");
        str = str.replace(/　/g, "");
        str = str.replace(/\r\n?/g, "");

        return str;

    };

    $.replaceAll = function (text, searchString, replacement) {

        if (typeof text != "string")
            return text;

        /*
        var replaceAll2 = function(str, before, after) {
        };
        */

        //置換のコード変えてみた
        var result = text.split(searchString).join(replacement);

        return result;


        //return text.replace(new RegExp(searchString, "g"), replacement);


    };

    //文字列を指定の数部分で切り取って返却します
    $.cutstr = function (str, num) {

        if (str) {

            //文字列が指定のインデックスより大きい場合
            if (str.length > num) {

                str = str.substring(0, num) + "...";

            }

        } else {
            return null;
        }

        return str;

    };
    //指定した拡張子を付ける。拡張子がなければ
    $.setExt = function (name, ext_str) {

        var tmp = name.split(".");
        if (tmp.length == 1) {
            name = name + "." + ext_str;
        }

        return name;

    },

        //配列入れ替え。
        $.array_replace = function (array, index1, index2) {

            var tmp = array[index1];
            //index1を削除
            array.splice(index1, 1);
            //削除
            //index2に挿入
            array.splice(index2, 0, tmp);
            return array;
        },

        //要素をクローンします
        $.cloneObject = function (source) {

            return $.extend(true, {}, source);

        };

    $.layer = function (layer_name) {
        if (layer_name) {
            return "layer-" + layer_name;
        } else {
            return "";
        }
    };

    //透明度を適切な値に変更
    $.convertOpacity = function (val) {
        //255をマックスとして計算する

        var p = val / 255;

        return p;

    };

    //パスにfgimage bgimage image が含まれていた場合、それを適用する
    $.convertStorage = function (path) {

    }, $.convertColor = function (val) {

        if (val.indexOf("0x") != -1) {
            return val.replace("0x", "#");
        }

        return val;

    };

    $.convertBold = function (flag) {

        if (flag == "true") {
            return "bold";
        }

        return "";

    };

    $.send = function (url, obj, call_back) {
        //game.current_story_file = story_file;
        $.ajax({
            type: "POST",
            url: url,
            data: obj,
            dataType: 'json',
            complete: function () {
                //通信終了時の処理
                $.hideLoading();
            },
            success: function (data, status) {
                $.hideLoading();

                var data_obj = data;
                if (call_back) {
                    call_back(data_obj);
                }
            }
        });
    };

    $.loadText = function (file_path, callback) {
        var httpObj = jQuery.get(file_path + "?" + Math.floor(Math.random() * 1000000), null, function (obj) {

            var order_str = "";

            if (httpObj) {
                if (httpObj.responseText) {
                    order_str = httpObj.responseText;
                } else {

                    order_str = obj;

                }
            } else {

                order_str = obj;

            }

            callback(order_str);
            // createOrder
        });

        if (httpObj.statusText === "error") {
            $.alert($.s("ファイルが見つかりませんでした"));
        }

    };

    //クッキーを取得
    $.getCookie = function (key) {
        var tmp = document.cookie + ";";
        var index1 = tmp.indexOf(key, 0);
        if (index1 != -1) {
            tmp = tmp.substring(index1, tmp.length);
            var index2 = tmp.indexOf("=", 0) + 1;
            var index3 = tmp.indexOf(";", index2);
            return tmp.substring(index2, index3);
        }
        return null;
    };

    $.isNull = function (str) {
        if (typeof str === "undefined" || str == null) {
            return "";
        } else {

        }

        return str;
    };

    $.checkNull = function (obj) {

        if (obj) {
            return true;
        } else {
            return false;
        }
    };

    $.isNum = function (str) {

        if (str.match(/[^0-9]+/)) {
            return false;
        } else {
            return true;
        }

    };

    $.dstop = function () {

    };

    //ユーザ環境を取得
    $.userenv = function () {

        var ua = navigator.userAgent;
        if (ua.indexOf('iPhone') > -1) {
            return 'iphone';
        } else if (ua.indexOf('iPad') > -1) {
            return 'iphone';
        } else if (ua.indexOf('Android') > -1) {
            return 'andoroid';
        } else {
            return "pc";
        }

    };

    //ユーザのブラウザ情報を取得
    $.getBrowser = function () {

        var userAgent = window.navigator.userAgent.toLowerCase();

        if (userAgent.indexOf("msie") > -1) {
            return "msie";
        } else if (userAgent.indexOf("firefox") > -1) {
            return "firefox";
        } else if (userAgent.indexOf("opera") > -1) {
            return "opera";
        } else if (userAgent.indexOf("chrome") > -1) {
            return "chrome";
        } else if (userAgent.indexOf("safari") > -1) {
            return "safari";
        } else {
            return "unknown";
        }

    };

    $.swfName = function (str) {
        if (navigator.appName.indexOf("Microsoft") != -1) {
            return window[str];
        } else {
            return document[str];
        }
    };

    $.setStyle = function (j_obj, pm, array_style) {

        var css = {};

        //console.log("------------------setstyle");

        for (var i = 0; i < array_style.length; i++) {
            var tag_name = array_style[i];
            console.log(tag_name + ":" + pm[tag_name]);
            if (typeof pm[tag_name] !== 'undefined') {

                //変換が必要な部分
                if (typeof tyrano.define.convert_pm[tag_name] !== "undefined") {
                    if (pm[tag_name] == tyrano.define.convert_pm[tag_name][0]) {
                        css[tag_name] = tyrano.define.convert_pm[tag_name][1];
                    }
                } else {
                    pm[tag_name] += "";
                    if (pm[tag_name].match(/^[0-9]+$/)) {
                        css[tag_name] = parseInt(pm[tag_name]);
                    } else {
                        css[tag_name] = pm[tag_name];
                    }

                }
            }

        }

        j_obj.css(css);
    };

    //要素から空白のオブジェクトを削除して返却する
    $.minifyObject = function (obj) {

        for (key in obj) {
            if (obj[key] == null || obj[key] == "") {
                delete obj[key];
            }
        }

        return obj;

    };

    $.keys = function (obj) {
        var array = [];
        for (key in obj) {
            array.push(key);
        }
        return array;
    },

        //オブジェクトの個数をもってきます。1
        $.countObj = function (obj) {

            var num = 0;
            for (key in obj) {
                num++;
            }
            return num;
        };

    $.showLoading = function () {
        $("#modalbox_load").show();
        $("#overlay_load").show();
    };

    $.hideLoading = function () {
        $("#modalbox_load").hide();
        $("#overlay_load").hide();
    };

    //渡されたJqueryオブジェクトにクラスをセットします
    $.setName = function (jobj, str) {

        str = $.trim(str);

        if (str == "")
            return;

        var array = str.split(",");
        for (var i = 0; i < array.length; i++) {
            jobj.addClass(array[i]);

        }

    };

    //////////////////////////////
    //ローカライズ
    $.s = function (str) {

        if (global_lang && local[global_lang]) {
            var local_str = local[global_lang][str];
            if (local_str) {
                return local_str;
            } else {
                return str;
            }
            return local[global_lang][str];
        } else {
            return str;
        }

    };

    $.lang_html = function (j_array) {

        j_array.each(function () {
            var j_obj = $(this);
            var lang = j_obj.attr("data-lang");
            if (lang == "span") {
                var val = $.s(j_obj.html());
                j_obj.html(val);
            } else if (lang == "val") {
                var val = $.s(j_obj.val());
                j_obj.val(val);
            }
        });

    };

    $.isHanEisu = function (str) {

        str = (str == null) ? "" : str;

        const pattern = /^[a-zA-Z0-9_\-]+$/;
        return pattern.test(str);

    }

    $.inform = function (str, type) {
        if (type === "error") {
            alertify.error(str, type);
        } else {
            alertify.log(str, "success");
        }
    };

    $.alert = function (str, cb) {
        alertify.alert(str, function () {
            ;
            if (typeof cb == "function") {
                cb();
            }
        });
    };



    $.confirm = function (str, cb_ok, cb_cancel) {

        alertify.confirm(str, function (e) {
            if (e) {
                // user clicked "ok"
                cb_ok();
            } else {
                // user clicked "cancel"
                cb_cancel();
            }
        });

    };

    $.prompt = function (str, cb) {

        alertify.prompt(str, function (flag, text) {

            if (typeof cb == "function") {
                cb(flag, text);
            }

        });

    };

    $.alertProOnly = function (str) {

        if (!str) {
            str = "本機能はPro版のみ利用可能です。<br /><br />Pro版を確認しますか？";
        }

        $.confirm(str,
            function () {
                app.gui.openWeb("https://tyrano.jp/studio");
            },
            function () {
            }
        );
    },



        $.sleep = function (T) {
            var d1 = new Date().getTime();
            var d2 = new Date().getTime();
            while (d2 < d1 + 1000 * T) {    //T秒待つ 
                d2 = new Date().getTime();
            }
            return;
        };

    $.error_message = function (str) {
        $.alert(str);
    };

    //クッキー設定
    $.setCookie = function (key, val) {
        document.cookie = key + "=" + escape(val) + ";expires=Fri, 31-Dec-2030 23:59:59;path=/;";
    }
})(jQuery);

jQuery.fn.outerHTML = function (s) {
    if (s) {
        this.before(s);
        this.remove();
        return this;
    } else {
        var dummy = jQuery("<p>");
        var elem = this.eq(0);
        dummy.append(elem.clone());
        return dummy.html();
    }
};

jQuery.fn.exists = function () { return Boolean(this.length > 0); }

/*
var valid_methods = {

    "required" : {
        exp : function(val) {
            return !($.trim(val) === "");
        },
        message : $.s("必須入力です")
    },
    "alphabet" : {
        exp : function(val) {
            return /^[a-zA-Z0-9_]+$/.test(val);
        },
        message : $.s("半角英数で入力してください")
    },

    "number" : {
        exp : function(val) {
            return !isNaN(val);
        },
        message : $.s("数字で入力してください")

    }

};
*/

//
//$("param-box").find(name).valid(["requeid","number"]);
jQuery.fn.valid = function (rules) {
    var val = this.val();
    var error_msg = "";
    for (rule in rules) {
        if (!valid_methods[rule].exp(val)) {
            error_msg += valid_methods[rule].message;
            break;
        }
    }
    if (error_msg != "") {
        this.next(".error").remove();
        this.after("<div class='error'>" + error_msg + "</div>");
        return false;
    } else {
        return true;
    }

};

