//メニューバー
class MenuBar {

  constructor(mainWindow) {

    this.mainWindow = mainWindow;

    this.initMenu();

  }

  initMenu() {

    const Menu = require('electron').Menu;

    // ElectronのMenuの設定
    const templateMenu = [
      {
        label: 'Studio',
        submenu: [

          {
            label: "Properties",
            click: (item, focusedWIndow) => {
              this.send("menu-prop");
            }
          },
          {
            label: 'Close',
            role: 'close',
          },
        ]
      },
      {
        label: 'Edit',
        submenu: [
          {
            label: 'Reload',
            accelerator: 'CmdOrCtrl+R',
            click(item, focusedWindow) {
              if (focusedWindow) focusedWindow.reload()
            },
          },
          {
            type: 'separator',
          },
          {
            label: "Undo",
            role: 'undo',
          },
          {
            label: "Redo",
            role: 'redo',
          },
          {
            type: 'separator',
          },
          {
            label: "Cut",
            role: 'cut',
          },
          {
            label: "Copy",
            role: 'copy',
          },
          {
            label: "Paste",
            role: 'paste',
          },
          {
            type: 'separator',
          },
          {
            label: "SelectAll",
            role: 'selectall',
          },
        ]
      },
      {
        label: 'Help',
        submenu: [
          {
            label: "About TyranoStudio",
            click: (item, focusedWIndow) => {

              this.send("menu-version");
            }
          },
        ]
      }
    ];

    let menu = Menu.buildFromTemplate(templateMenu);
    Menu.setApplicationMenu(menu);

  }

  send(value) {
    this.mainWindow.webContents.send('asynchronous-message', value);
  }

}

module.exports = {
  MenuBar: MenuBar,
}

