/*
Rule Transition Plugin v1.0.0
Includes:
# forked: forked from: Universal Transition - http://jsdo.it/nosemint/9OWJ
Licensed under the MIT license - http://opensource.org/licenses/MIT
*/


(function($, TYRANO, object){
    
    // このプラグインの複数回読込の禁止
    if (typeof TYRANO.kag.ftag.master_tag['bg_rule'] !== 'undefined') {
        return;
    }
    
    //
    // タグを定義
    //
    
    var tag = {};
    tag['bg_rule'] = {
        pm: {
            'storage'  : 'xxx.jpg',  // 次にセットする背景画像
            'color'    : '',         // 次にセットする背景色
            'rule'     : 'xxx.png',  // 適用するルール画像
            'time'     : '1000',     // 時間
            'wait'     : 'true',     // ウェイトするか
            'clickskip': 'false',    // クリックでスキップできるようにするか
            'reverse'  : 'true'
        },
        start: function (pm) {
            // mainCanvasを取得し直す
            // ※ セーブ＆ロードでDOMの連続性が失われている可能性があるため
            mainCanvas = document.getElementById('canvas_bg_rule');
            mainCanvas.ctx = mainCanvas.getContext('2d');
            // 現在トランジション中なら強制的に終了させる
            if (isTrans) {
                finishTransition();
                // ※[bg_rule wait=false ...]を極めて短い間隔で並べた場合などに対応するため
            }
            // 画像ソースを変換(httpの場合など)
            var nextImageSrc = parseSrc(pm.storage, './data/bgimage/');
            var ruleImageSrc = parseSrc(pm.rule, './data/image/bg_rule/');
            // pm.colorが指定されている場合は上書き
            if (pm.color) {
                nextImageSrc = 'color:' + parseColor(pm.color);
            }
            var time   = parseInt(pm.time);         // トランジション時間
            enableSkip = (pm.clickskip === 'true'); // クリックでスキップできるようにするか
            isWait     = (pm.wait === 'true');      // ウェイトを有効にするか
            isReverse  = (pm.reverse === 'true');   // ルールを反転するか
            // 現在ティラノスクリプトがスキップ中＋ショートカット有効なら
            if (isSkip() && enableShortCut) {
                // トランジション時間はゼロで上書きしよう
                time = 0;
            }
            // トランジション開始
            beginTransition(getPrevImageSrc(), nextImageSrc, ruleImageSrc, time);
            // ウェイト無効ならば
            if (!isWait) {
                // nextOrder
                this.kag.ftag.nextOrder();
            }
        }
    };
    
    // タグをビルド
    var master_tag = TYRANO.kag.ftag.master_tag;
    for (var tag_name in tag) {
        master_tag[tag_name] = object(tag[tag_name]);
        master_tag[tag_name].kag = TYRANO.kag;
    }
    
    //
    // 変数定義
    //
    
    var requestAnimationFrame = 
        window.requestAnimationFrame       ||
        window.webkitRequestAnimationFrame ||
        window.mozRequestAnimationFrame    ||
        window.oRequestAnimationFrame      ||
        window.msRequestAnimationFrame     ||
        function (callback) {
            return window.setTimeout(callback, 1000 / 60);
        };
    var cancelAnimationFrame =
        window.cancelAnimationFrame              ||
        window.webkitCancelRequestAnimationFrame ||
        window.mozCancelRequestAnimationFrame    ||
        window.oCancelRequestAnimationFrame      ||
        window.msCancelRequestAnimationFrame     ||
        function (timerId) {
            clearTimeout(timerId);
        };
    var SCREEN_WIDTH  = parseInt(TYRANO.kag.config.scWidth);
    var SCREEN_HEIGHT = parseInt(TYRANO.kag.config.scHeight);
    var renderTimerId = null;
    var prevImage     = null;
    var nextImage     = null;
    var ruleImage     = null;
    var currentRule   = null;
    var currentAlpha  = null;
    var cacheRule     = {};
    var passedTime    = null;
    var prevTime      = null;
    var transTime     = null;
    var transFrame    = 0;
    var transSpeed    = 1;
    var isTrans       = false;
    var enableSkip    = true;
    var isWait        = true;
    var isReverse     = false;
    var enableShortCut= (TYRANO.kag.stat.mp.shortcut !== 'false'); 
    
    //
    // 既存関数改造
    //
    
    // トランジション中＋ウェイト有効＋スキップ不可中にクリックされたら帰る
    var oldNextOrder = TYRANO.kag.ftag.nextOrder;
    TYRANO.kag.ftag.nextOrder = function () {
        if (isTrans && isWait && !enableSkip) {
            return false;
        }
        oldNextOrder.apply(this, arguments);
    };
    
    // トランジション中にロード処理が走ったら強制終了する
    var oldLoadGameData = TYRANO.kag.menu.loadGameData;
    TYRANO.kag.menu.loadGameData = function () {
        if (isTrans) {
            isWait = false;
            finishTransition();
        }
        oldLoadGameData.apply(this, arguments);
    };
    
    //
    // DOMおよびイベントリスナーの追加
    //
    
    // メインキャンバスの作成
    var mainCanvas = createCanvas(SCREEN_WIDTH, SCREEN_HEIGHT);
    mainCanvas.id = 'canvas_bg_rule';
    mainCanvas.style.position = 'absolute';
    mainCanvas.style.zIndex = '1';
    
    // ドキュメントへの挿入
    appendCanvas(mainCanvas);
    
    // イベントリスナーの設定
    addEventListener(mainCanvas);
    
    //
    // 以下関数定義
    //
    
    // @createCanvas
    // <canvas>要素を作って返します
    function createCanvas (width, height) {
        var canvasElement = document.createElement('canvas');
        canvasElement.width = width;
        canvasElement.height = height;
        canvasElement.ctx = canvasElement.getContext('2d');
        return canvasElement;
    }
    
    // @appendCanvas
    // <canvas>要素をドキュメントに挿入します
    function appendCanvas (canvasElement) {
        //document.body.appendChild(canvasElement);
        //$(canvasElement).prependTo("#root_layer_game");
        // baseレイヤーの中に入れてみよう
        // baseレイヤーにかかっているカメラ効果がキャンバスに対してもかかるようになる
        $('#tyrano_base').find('.base_fore').eq(0).append(canvasElement);
    }
    
    // @addEventListener
    // イベントリスナーを追加します
    function addEventListener (canvasElement) {
        // イベントレイヤーをクリックしたときの処理
        TYRANO.kag.layer.layer_event.on('click.bg_rule', function () {
            // トランジション中＋ウェイト有効＋スキップ可でクリックされたら
            if (isTrans && isWait && enableSkip) {
                // トランジションをスキップする
                skipTransition();
            }
        });
    }
    
    // @beginTransition
    // トランジションを開始します
    function beginTransition (prevImageSrc, nextImageSrc, ruleImageSrc, _transTime) {
        // 変数初期化
        transFrame   = 0;
        transSpeed   = 1;
        currentAlpha = 0;
        passedTime   = 0;
        prevTime     = getTime();
        transTime    = _transTime;
        // 画像ロード
        var loader = new ImageLoader(0, 3, function () {
            loader.onload = null;
            // トランジション時間が0より大きいなら
            if (transTime > 0) {
                // イベントレイヤーを表示
                TYRANO.kag.layer.showEventLayer();
                // Ruleオブジェクトをゲットして
                currentRule = getRule(ruleImageSrc);
                // レンダー開始
                startRender();
            }
            // トランジション時間が0なら
            else {
                // 直接終了処理に飛ぶ
                finishTransition();
            }
        });
        prevImage = loader.load(prevImageSrc);
        nextImage = loader.load(nextImageSrc);
        ruleImage = loader.load(ruleImageSrc);
    }
    
    // @getTime
    // 現在のミリ秒単位の時刻を取得します
    function getTime () {
        return new Date().getTime();
    }
    
    // @getRule
    // ルールイメージソースを引数にとってRuleオブジェクトを返します
    // キャッシュがあればそれを返す
    // キャッシュがなければコンストラクタから新規作成
    function getRule (ruleImageSrc) {
        if (typeof cacheRule[ruleImageSrc] === 'undefined') {
            cacheRule[ruleImageSrc] = new Rule(ruleImage, SCREEN_WIDTH, SCREEN_HEIGHT);
        }
        return cacheRule[ruleImageSrc];
    }
    
    // @getPrevImageSrc
    // トランジションを開始する前の背景を特定します
    function getPrevImageSrc () {
        // bareレイヤーを取得
        var base = document.getElementsByClassName("base_fore")[0];
        var url = base.style.backgroundImage;
        var ret;
        // background-imageが指定されている
        if (url !== 'none' && url !== '') {
            var iUseMark = 0;
            var startMarks = ['\"', '\'', '('];
            var endMarks = ['\"', '\'', ')'];
            for (var i = 0; i < 3; i++) {
                if (url.indexOf(startMarks[i]) > -1) {
                    iUseMark = i;
                    break;
                }
            }
            var a = url.indexOf(startMarks[iUseMark]);
            var b = url.lastIndexOf(endMarks[iUseMark]);
            // スタートマークの次の文字からエンドマークの前の文字までを取得
            ret = url.substr(a + 1, b - a - 1);
        }
        // background-imageが指定されていない
        else {
            ret = 'color:' + base.style.backgroundColor;
        }
        return ret;
    }
    
    // @ImageLoader
    // 画像ロード用のオブジェクト
    function ImageLoader (count, needCount, onload) {
        this.count = count;
        this.needCount = needCount;
        this.onload = onload;
        return this;
    }
    
    // @ImageLoader.load
    // <img>要素を作って返します
    // ※引数iamgeSrcが'color:'から始まる文字列であれば<img>要素を生成せず
    //   'color:'を除いた文字列をそのまま返します
    // <img>要素のロードが完了した時点でImageLoader.countが増加
    // ImageLoader.countとImageLoader.needCountが一致したらImageLoader.onloadが発火します
    ImageLoader.prototype.load = function (imageSrc) {
        var that = this;
        if (imageSrc.indexOf('color:') === 0) {
            that.needCount--;
            if (that.count === that.needCount) {
                setTimeout(function () {
                    if (typeof that.onload === 'function') {
                        that.onload();
                    }
                }, 1);
            }
            return imageSrc.substr(6);
        }
        var imageElement = document.createElement('img');
        imageElement.onload = function (e) {
            that.count++;
            if (that.count === that.needCount) {
                if (typeof that.onload === 'function') {
                    that.onload();
                }
            }
        };
        imageElement.onerror = function () {
            TYRANO.kag.error('\n画像ファイル「'+imageSrc+'」を探しましたが、見つかりませんでした。');
        };
        imageElement.src = imageSrc;
        return imageElement;
    };
    
    // @startRender
    // トランジションのレンダーを開始します
    function startRender () {
        //TYRANO.kag.stat.is_wait = true;
        prevTime = getTime();
        isTrans = true;
        render();
    }
    
    // @render
    // 現在のフレームを描画します
    // 描画の度に繰り返し呼ぶ必要があります
    function render () {
        //console.log(transFrame);
        transFrame++;
        // 次回レンダーの予約
        cancelAnimationFrame(renderTimerId);
        renderTimerId = requestAnimationFrame(render);
        // 現在の時間を取得
        var now = getTime();        // 現在の時間を取得
        var dif = now - prevTime;   // 前回の時間との差（＝経過ミリ秒）を計算
        dif = dif * transSpeed;     // スピードをかける
        passedTime += dif;          // 合計時間に経過ミリ秒を足す
        prevTime = now;             // 前回の時間に現在の時間を代入（次回フレームで使用）
        // 進行度の計算
        currentAlpha = passedTime / transTime;
        // メイン処理
        mainCanvas.ctx.save();
        drawImageOrColor(mainCanvas.ctx, prevImage, SCREEN_WIDTH, SCREEN_HEIGHT);
        currentRule.applyRule(mainCanvas.ctx, currentAlpha);
        mainCanvas.ctx.globalCompositeOperation = 'destination-over';
        drawImageOrColor(mainCanvas.ctx, nextImage, SCREEN_WIDTH, SCREEN_HEIGHT);
        mainCanvas.ctx.restore();
        if (transFrame === 1) {
            changeBaseLayer(nextImage);
        }
        // 進行度が1より大きかったら終了していい
        if (currentAlpha > 1) {
            finishTransition();
        }
    }
    
    // @finishTransition
    // トランジションを終了します
    function finishTransition () {
        // ステートの変更
        isTrans = false;
        // レンダーの予約を取り消す
        cancelAnimationFrame(renderTimerId);
        // baseレイヤーのstyleの書き換え
        changeBaseLayer(nextImage);
        // キャンバスのクリア
        mainCanvas.ctx.clearRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
        // ウェイト有効ならnextOrder
        if (isWait) {
            TYRANO.kag.ftag.nextOrder();
        }
    }
    
    // @changeBaseLayer
    // baseレイヤーの背景を変更します
    function changeBaseLayer (nextImage) {
        // baseレイヤーのstyleの書き換え
        var base = document.getElementsByClassName("base_fore")[0];
        if (typeof nextImage !== 'string') {
            base.style.backgroundColor = "rgba(0, 0, 0, 0)";
            base.style.backgroundImage = "url('" + nextImage.src + "')";
        }
        else {
            base.style.backgroundImage = "none";
            base.style.backgroundColor = nextImage;
        }
    }
    
    // @skipTransition
    // トランジションをスキップします
    function skipTransition () {
        if (isTrans) {
            finishTransition();
        }
    }
    
    // @drawImageOrColor
    // 指定したコンテキストに特定の色または画像を描画します
    function drawImageOrColor (ctx, imageOrColor, width, height) {
        if (typeof imageOrColor !== 'string') {
            ctx.drawImage(imageOrColor, 0, 0, width, height);
        }
        else {
            ctx.fillStyle = imageOrColor;
            ctx.fillRect(0, 0, width, height);
        }
    }
    
    // @isSkip
    // ティラノスクリプトがいまスキップ中かを取得する
    function isSkip () {
        return TYRANO.kag.stat.is_skip === true || TYRANO.kag.stat.is_nowait === true;
    }
    
    // @parseSrc
    // ソースの変換
    function parseSrc (src, base) {
        if (src.substr(0, 4) === 'http') {
            return src;
        }
        else {
            return base + src;
        }
    }
    
    // @parseColor
    // カラーの変換
    function parseColor (color) {
        if (color.indexOf("0x") != -1) {
            return color.replace("0x", "#");
        }
        return color;
    }
    
    // @Rule
    // Ruleオブジェクトのコンストラクタ
    function Rule (imageElement, width, height) {
        
        //
        // 引数の格納
        //
        
        this.imageElement = imageElement;
        this.width = width;
        this.height = height;
        
        //
        // 内部的にキャンバスを作成
        //
        
        this.tempCanvas1  = createCanvas(width, height);
        this.tempCanvas2  = createCanvas(width, height);
        this.alphaCanvas1 = createCanvas(width, height);
        this.alphaCanvas2 = createCanvas(width, height);
        // alphaCanvas1は「ルール画像の黒部分が透け、白部分が残っている」キャンバス
        // alphaCanvas2は「ルール画像の白部分が透け、黒部分が残っている」キャンバス
        
        //
        // 白黒画像をアルファに変換する作業
        //
        
        // alphaCanvas1
        this.alphaCanvas1.ctx.drawImage(imageElement, 0, 0, width, height);
        var imagedata = this.alphaCanvas1.ctx.getImageData(0, 0, width, height);
        var size = SCREEN_WIDTH * SCREEN_HEIGHT * 4;
        for (var i = 0; i < size; i += 4) {
            // RGBAのR値をAに持ってくる
            imagedata.data[i + 3] = imagedata.data[i];
        }  
        this.alphaCanvas1.ctx.putImageData(imagedata, 0, 0);
        
        // alphaCanvas1を反転してalphaCanvas2を作る
        this.alphaCanvas2.ctx.fillStyle = '#000000';
        this.alphaCanvas2.ctx.globalCompositeOperation = 'xor';
        this.alphaCanvas2.ctx.fillRect(0, 0, width, height);
        this.alphaCanvas2.ctx.drawImage(this.alphaCanvas1, 0, 0, width, height);
    }
    
    // @Rule.applyRule
    // ルールを適用します
    Rule.prototype.applyRule = function (ctx, ratio) {
        ctx.save();
        // 消しゴムをかける
        ctx.globalCompositeOperation = 'xor';
        ctx.drawImage(this.makeRule(ratio), 0, 0);
        ctx.restore();
        return ctx;
    };
    
    // @Rule.makeRule
    // 適用するためのルールキャンバスを生成します
    Rule.prototype.makeRule = function (ratio) {
        var c1 = this.tempCanvas1.ctx;
        var c2 = this.tempCanvas2.ctx;
        var a1 = this.alphaCanvas1;
        var a2 = this.alphaCanvas2;
        if (isReverse) {
            a1 = this.alphaCanvas2;
            a2 = this.alphaCanvas1;
        }
        var a;
        // 一時キャンバスのリセット
        this.tempCanvas1.width = this.tempCanvas1.width;
        this.tempCanvas2.width = this.tempCanvas2.width;
        // なぜ上記でリセットできるのか不明(´･ω･`)
        // 操作としては以下と同じだが…
        /*
        c1.globalCompositeOperation = 'source-over';
        c2.globalCompositeOperation = 'source-over';
        c1.clearRect(0, 0, 1000, 1000);
        c2.clearRect(0, 0, 1000, 1000);
        */
        // 進行度が50%以下の場合
        if (ratio <= 0.5) {
            // ratio(0→0.5)に対して(1→0)となるような値を計算しaとする
            a = 1 - ratio * 2;
            c2.drawImage(a1, 0, 0);
            c2.globalCompositeOperation = 'lighter';
            c2.fillStyle = 'rgba(0, 0, 0,' + a + ')';
            c2.fillRect(0, 0, this.width, this.height);
            c1.fillStyle = '#000000';
            c1.fillRect(0, 0, this.width, this.height);
            c1.globalCompositeOperation = 'xor'; // destination-out としても同じ
            c1.drawImage(this.tempCanvas2, 0, 0, this.width, this.height);
        }
        // 進行度が50%より大きい場合
        else {
            // ratio(0.5→1)に対して(0→1)となるような値を計算しaとする
            a = (ratio - 0.5).toFixed(5) * 2;
            c1.drawImage(a2, 0, 0, this.width, this.height);
            c1.globalCompositeOperation = 'lighter';
            c1.fillStyle = 'rgba(0, 0, 0,' + a + ')';
            c1.fillRect(0, 0, this.width, this.height);
        }
        return this.tempCanvas1;
    };
    
}(window.jQuery, window.TYRANO, window.object));