//メニューなどを制御する

class DialogManager {

  constructor() {

    const electron = require('electron');
    const ipcMain = electron.ipcMain;

    this.dialog = require("electron").dialog;
    this.ipcMain = ipcMain;
    this.path = require("path");

    this.electron = electron;

    ipcMain.on('showSelectFileDialog', async (event, arg) => {
      console.log('receive message: showSelectFileDialog');
      let obj = this.showSelectFileDialog(arg);
      event.returnValue = obj;
    });

    ipcMain.on('showSaveDialog', async (event, arg) => {
      let obj = this.showSaveFileDialog(arg);
      event.returnValue = obj;
    });

  }

  test() {
    console.log("test");
  }

  showSelectFileDialog(opt) {

    let title = opt.title || "";
    let extensions = opt.extensions || [];
    let prop = opt.prop || ['openFile'];

    let windows = this.electron.BrowserWindow.getAllWindows();
    const mainWindow = windows.find(window => window.title === 'TyranoStudio');


    let filenames = this.dialog.showOpenDialogSync(
      //require('electron').remote.getCurrentWindow(),
      mainWindow,
      {
        properties: prop,
        title: title,
        filters: [
          { name: '', extensions: extensions }
        ]
      }
    );

    if (typeof filenames == "undefined") {
      return undefined;
    }

    let filepath = filenames[0];

    let fileobj = {
      filepath: filepath,
      filename: this.path.basename(filepath),
      dirname: this.path.dirname(filepath)
    }

    return fileobj;

  }

  showSaveFileDialog(opt) {

    let title = opt.title || "";
    let filename = opt.filename || "";

    let windows = this.electron.BrowserWindow.getAllWindows();
    const mainWindow = windows.find(window => window.title === 'TyranoStudio');

    let file = this.dialog.showSaveDialogSync(
      mainWindow,
      {
        defaultPath: filename,
        title: title
      }
    );

    return file;
  }

}

module.exports = {
  Dialog: DialogManager,
}




